import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Define colors for statuses
clear_color = 'green'
table_color = 'gray'
empty_color = 'blue'

# Define dimensions for blocks and table
block_width = 1
block_height = 0.5
table_height = 0.3

# Table
table = patches.Rectangle((0, 0), 4, table_height, linewidth=1, edgecolor='black', facecolor=table_color)
ax.add_patch(table)
ax.text(2, 0.1, 'Table', ha='center', va='center', fontsize=10, color='black')

# Block A (bottom-left)
block_a = patches.Rectangle((0.5, table_height), block_width, block_height, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_a)
ax.text(1, table_height + 0.25, 'A\nclear', ha='center', va='center', fontsize=9, color='white')

# Block B (bottom-center)
block_b = patches.Rectangle((1.75, table_height), block_width, block_height, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_b)
ax.text(2.25, table_height + 0.25, 'B\nclear', ha='center', va='center', fontsize=9, color='white')

# Block C (bottom-center)
block_c = patches.Rectangle((1.75, table_height), block_width, block_height, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_c)
ax.text(2.25, table_height + 0.25, 'C\nclear', ha='center', va='center', fontsize=9, color='white')

# Block D (bottom-right)
block_d = patches.Rectangle((3, table_height), block_width, block_height, linewidth=1, edgecolor='black', facecolor=clear_color)
ax.add_patch(block_d)
ax.text(3.5, table_height + 0.25, 'D\nclear', ha='center', va='center', fontsize=9, color='white')

# Hand (above the table)
hand = patches.Circle((3.5, 2.5), 0.2, linewidth=1, edgecolor='black', facecolor=empty_color)
ax.add_patch(hand)
ax.text(3.5, 2.5, 'Hand\nempty', ha='center', va='center', fontsize=9, color='white')

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear'),
    patches.Patch(facecolor=table_color, edgecolor='black', label='Table'),
    patches.Patch(facecolor=empty_color, edgecolor='black', label='Empty Hand')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and hide axes
ax.set_xlim(0, 5)
ax.set_ylim(0, 3)
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()